/* - StepperVelocityListener -
 * Display the data from the velocity change event
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.PhidgetException;
import com.phidgets.StepperPhidget;
import com.phidgets.event.StepperVelocityChangeListener;
import com.phidgets.event.StepperVelocityChangeEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
/**
 *
 * @author Owner
 */
public class StepperVelocityListener implements StepperVelocityChangeListener{
    
    private JComboBox motorCmb;
    private JTextField velActualTxt;
    private JFrame appFrame;
    private JSlider currentPosScrl;
    private JCheckBox stoppedChk;
    
    /**
     * Creates a new instance of StepperVelocityListener
     */
    public StepperVelocityListener(JFrame appFrame, JComboBox motorCmb, JTextField velActualTxt, JCheckBox stoppedChk, JSlider currentPosScrl)
    {
        this.appFrame = appFrame;
        this.motorCmb = motorCmb;
        this.velActualTxt = velActualTxt;
        this.stoppedChk = stoppedChk;
        this.currentPosScrl = currentPosScrl;
    }

    public void stepperVelocityChanged(StepperVelocityChangeEvent stepperVelocityChangeEvent)
    {
        if(stepperVelocityChangeEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            try
            {
                velActualTxt.setText(Double.toString(stepperVelocityChangeEvent.getValue()));
                stoppedChk.setSelected(((StepperPhidget)stepperVelocityChangeEvent.getSource()).getStopped(stepperVelocityChangeEvent.getIndex()));
                if(!currentPosScrl.isFocusOwner())
                {
                    currentPosScrl.setEnabled(((StepperPhidget)stepperVelocityChangeEvent.getSource()).getStopped(stepperVelocityChangeEvent.getIndex()));
                }
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
}
